/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.integrator.adaptors.webservices;

import filenet.vw.api.VWAttachment;
import filenet.vw.api.VWException;
import filenet.vw.api.VWSession;
import filenet.vw.base.StringUtils;
import filenet.vw.base.VWString;
import filenet.vw.base.VWXMLWrapper;
import filenet.vw.base.XMLHelper;
import filenet.vw.base.logging.Logger;
import filenet.ws.api.WSBindingInOutBase;
import filenet.ws.api.WSBindingOperation;
import filenet.ws.api.WSDefinition;
import filenet.ws.api.WSMIMEPart;
import filenet.ws.api.WSMessage;
import filenet.ws.api.WSParam;
import filenet.ws.api.WSParamLeaf;
import filenet.ws.api.WSParamParent;
import filenet.ws.api.WSPart;
import filenet.ws.utils.WSLogger;
import filenet.ws.utils.WSSchemaValidator;
import filenet.ws.utils.WSSchemaValidatorResult;
import filenet.ws.utils.att.IWSAttLoader;
import filenet.ws.utils.att.IWSAttSession;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.URL;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import javax.wsdl.Part;
import javax.wsdl.extensions.mime.MIMEContent;
import javax.wsdl.extensions.mime.MIMEPart;
import javax.xml.namespace.QName;
import org.apache.axis.encoding.Base64;
import org.apache.axis.types.HexBinary;
import org.w3c.dom.Node;

public class WSRequestOperation {
    protected static final String m_className = "WSRequestOperation";
    protected int m_tIndex = 1;
    protected String m_op = null;
    protected WSLogger m_wsLogger = new WSLogger("WS-Request");
    protected String m_outputMsg = "";
    protected String m_fault = "";
    protected IWSAttSession m_WSAttSession = null;
    protected VWSession m_PESession = null;
    protected static Logger logger = Logger.getLogger("filenet.vw.ComponentIntegrator.WebServices");
    protected String m_endPoint = null;
    protected String m_portType = null;
    protected String m_wsdlRef = null;
    protected String m_partnerLinkRef = null;
    protected String m_listenerURL = null;
    protected String m_inputMsg = null;
    protected String m_inputMsgName = null;
    protected String m_outputMsgName = null;
    protected String m_endPointRef = null;
    protected VWAttachment m_wsFolder = null;
    protected boolean m_wsdlIsFromPE = false;
    protected String m_wcName = null;
    protected int m_status = -1;
    private static Hashtable g_WSDLCache = new Hashtable();
    private static Hashtable g_WSDLStringCache = new Hashtable();
    private static long g_WSDLCache_TimeStamp = -1L;
    protected long m_cacheTimeout = 0L;
    protected int m_wsTimeout = 300000;
    protected String[] m_rpcOutMsgParts = null;
    protected String[] m_rpcOutAccessors = null;
    protected boolean m_validateMessages = true;
    WSDefinition m_wsDefinition = null;
    private static String g_ClientName = null;
    protected Hashtable m_namespaces = new Hashtable(5);

    public static String _get_FILE_DATE() {
        return "$Date:   15 Oct 2008 08:05:00  $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author:   qdang  $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision:   1.45  $";
    }

    protected static String getClientName() {
        if (g_ClientName == null) {
            try {
                g_ClientName = InetAddress.getLocalHost().getHostName() + "(" + InetAddress.getLocalHost().getHostAddress() + ") ";
            }
            catch (Exception e) {
                g_ClientName = "localhost ";
            }
        }
        return g_ClientName;
    }

    public WSRequestOperation(VWSession PESession, IWSAttSession WSAttSession, int wsTimeout, boolean traceIt, String traceFile, long fileSize, long cacheTimeout, boolean validateMessages, int tIndex) {
        this.m_tIndex = tIndex;
        this.m_WSAttSession = WSAttSession;
        this.m_PESession = PESession;
        this.m_wsTimeout = wsTimeout;
        this.m_cacheTimeout = cacheTimeout;
        this.m_wsLogger.setTraceToFile(traceIt);
        if (traceFile != null && traceIt) {
            this.m_wsLogger.setFileName(traceFile);
        }
        this.m_wsLogger.setFileSize(fileSize);
        this.m_validateMessages = validateMessages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void ClearWSDLCacheExceptOne(String wsdlEndPointInUse, WSDefinition wsDefInUse) {
        Enumeration e;
        Hashtable hashtable = g_WSDLCache;
        synchronized (hashtable) {
            e = g_WSDLCache.keys();
            while (e.hasMoreElements()) {
                Object obj = g_WSDLCache.remove(e.nextElement());
                if (obj == null || obj == wsDefInUse) continue;
                ((WSDefinition)obj).releaseReferences();
                obj = null;
            }
            g_WSDLCache.clear();
            if (wsdlEndPointInUse != null && wsDefInUse != null) {
                g_WSDLCache.put(wsdlEndPointInUse, wsDefInUse);
            }
        }
        hashtable = g_WSDLStringCache;
        synchronized (hashtable) {
            e = g_WSDLStringCache.keys();
            while (e.hasMoreElements()) {
                g_WSDLStringCache.remove(e.nextElement());
            }
            g_WSDLStringCache.clear();
        }
        if (logger.isFinest()) {
            logger.finest(m_className, "ClearWSDLCacheExceptOne", "Called.");
        }
    }

    protected static void checkRequiredParameters(Object param, String paramName) throws VWException {
        if (param == null) {
            throw new VWException("ws.WSOperations.missingParams", "Missing required parameters. {0} is null.", paramName);
        }
        if (logger.isFinest()) {
            logger.finest(m_className, paramName, param.toString());
        }
    }

    public static void ClearWSDLCache() {
        WSRequestOperation.ClearWSDLCacheExceptOne(null, null);
    }

    protected void traceData() {
        if (!logger.isFinest()) {
            return;
        }
        StringBuffer buf = new StringBuffer();
        buf.append("EndPoint=").append(this.m_endPoint);
        buf.append(", portType=").append(this.m_portType);
        buf.append(", op=").append(this.m_op);
        buf.append(", inputmsg=").append(this.m_inputMsg);
        buf.append(", endpointRef=").append(this.m_endPointRef);
        buf.append(", wsFolder=").append(this.m_wsFolder);
        logger.finest(m_className, "traceData", buf.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getWSDLDefinitionAsString(WSDefinition wsDef) {
        String s = null;
        Hashtable hashtable = g_WSDLStringCache;
        synchronized (hashtable) {
            s = (String)g_WSDLStringCache.get(wsDef);
        }
        if (s == null) {
            try {
                s = wsDef.writeToString();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return s;
    }

    protected WSDefinition getWSDLDefinition(String endPoint, String alternateEndpoint, long baseInterval, long timeout) throws Exception {
        String m_method = "getWSDLDefinition(" + endPoint + ", " + alternateEndpoint + ", " + baseInterval + ", " + timeout + ")";
        if (alternateEndpoint == null || alternateEndpoint.equals(endPoint)) {
            return this.getWSDLDefinition(endPoint, baseInterval, timeout);
        }
        Object definition = null;
        return this.getWSDLDefinition(endPoint, alternateEndpoint);
    }

    protected WSDefinition getWSDLDefinition(String endPoint, long baseInterval, long timeout) throws Exception {
        String m_method = "getWSDLDefinition(" + endPoint + ", " + baseInterval + ", " + timeout + ")";
        Object definition = null;
        return this.getWSDLDefinition(endPoint);
    }

    protected WSDefinition getWSDLDefinition(String endPoint, String alternateEndpoint) throws Exception {
        String m_method = "getWSDLDefinition(" + endPoint + "," + alternateEndpoint + ")";
        WSDefinition definition = null;
        if (alternateEndpoint == null || endPoint.equals(alternateEndpoint)) {
            return this.getWSDLDefinition(endPoint);
        }
        try {
            definition = this.getWSDLDefinition(endPoint);
            this.m_endPoint = endPoint;
        }
        catch (Exception we) {
            try {
                if (logger.isFinest()) {
                    logger.finest(m_className, m_method, "Let's try " + alternateEndpoint);
                }
                definition = this.getWSDLDefinition(alternateEndpoint);
                this.m_endPoint = alternateEndpoint;
            }
            catch (Exception we2) {
                logger.throwing(m_className, m_method, we2);
                throw we2;
            }
        }
        return definition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected WSDefinition getWSDLDefinition(String endPoint) throws Exception {
        long curTime;
        String m_method = "getWSDLDefinition:" + endPoint;
        if (this.m_wsDefinition != null) {
            return this.m_wsDefinition;
        }
        boolean cacheIt = this.m_cacheTimeout != 0L;
        WSDefinition definition = null;
        if (cacheIt) {
            try {
                String wsURLPath = new URL(endPoint).getPath();
                if (wsURLPath.indexOf("P8BPMWSBroker") != -1) {
                    int nItems;
                    this.m_wsdlIsFromPE = true;
                    cacheIt = false;
                    String[] items = StringUtils.split(wsURLPath, "/");
                    int n = nItems = items == null ? 0 : items.length;
                    if (nItems > 4) {
                        try {
                            int wsId = Integer.parseInt(items[nItems - 1]);
                            cacheIt = true;
                        }
                        catch (Exception e) {}
                    }
                }
            }
            catch (Throwable e) {
                // empty catch block
            }
        }
        if (cacheIt) {
            Hashtable e = g_WSDLCache;
            synchronized (e) {
                definition = (WSDefinition)g_WSDLCache.get(endPoint);
            }
        }
        if ((g_WSDLCache.size() != 0 || g_WSDLStringCache.size() != 0) && this.m_cacheTimeout > 0L && this.m_cacheTimeout <= (curTime = new Date().getTime()) - g_WSDLCache_TimeStamp) {
            WSRequestOperation.ClearWSDLCacheExceptOne(endPoint, definition);
        }
        g_WSDLCache_TimeStamp = new Date().getTime();
        if (definition == null) {
            try {
                definition = WSDefinition.getWSDefinition(this.m_PESession, endPoint);
            }
            catch (ConnectException ce) {
                throw new ConnectException(endPoint);
            }
            if (cacheIt) {
                Hashtable hashtable = g_WSDLCache;
                synchronized (hashtable) {
                    g_WSDLCache.put(endPoint, definition);
                }
                hashtable = g_WSDLStringCache;
                synchronized (hashtable) {
                    g_WSDLStringCache.put(definition, definition.writeToString());
                }
            }
        }
        this.m_wsDefinition = definition;
        return definition;
    }

    protected void checkInlineAttachments() {
        int beginIndex = 0;
        int begin = 0;
        beginIndex = this.m_inputMsg.indexOf("<$FN_BEGIN_EXPANDATT>", begin);
        if (beginIndex == -1) {
            return;
        }
        String m_method = "checkInlineAttachments";
        if (this.m_WSAttSession == null) {
            if (logger.isFinest()) {
                logger.finest(m_className, "checkInlineAttachments", "Skipped attachment functionality.  No CE Session was available..");
            }
            return;
        }
        StringBuffer buf = new StringBuffer();
        do {
            if (beginIndex == -1) {
                buf.append(this.m_inputMsg.substring(begin));
                break;
            }
            int endIndex = this.m_inputMsg.indexOf("<$FN_END_EXPANDATT>", beginIndex);
            if (endIndex == -1) {
                return;
            }
            String attString = this.m_inputMsg.substring(beginIndex + "<$FN_BEGIN_EXPANDATT>".length(), endIndex);
            if (logger.isFinest()) {
                logger.finest(m_className, "checkInlineAttachments", "expanding att = " + attString);
            }
            buf.append(this.m_inputMsg.substring(begin, beginIndex));
            try {
                IWSAttLoader ceDoc = this.m_WSAttSession.getLoader(attString);
                byte[] contents = ceDoc.getContents();
                String ceDocContents = new String(contents);
                if (ceDocContents != null) {
                    buf.append(XMLHelper.toXMLString(ceDocContents));
                } else {
                    String s = new VWString("ws.WSOperations.GetAttContentsFailed", "The attempt to retrieve the attachment contents failed. The contents for the attachment {0} could not be retrieved.").toString(attString);
                    logger.warning(m_className, "checkInlineAttachments", s);
                }
            }
            catch (Exception e) {
                String s = new VWString("ws.WSOperations.GetAttContentsFailedWithException", "The attempt to retrieve the attachment contents failed. The contents for the attachment {0} could not be retrieved due to the following exception: {1}").toString(attString, e.getLocalizedMessage());
                logger.warning(m_className, "checkInlineAttachments", s);
            }
            begin = endIndex + "<$FN_END_EXPANDATT>".length();
            beginIndex = this.m_inputMsg.indexOf("<$FN_BEGIN_EXPANDATT>", begin);
        } while (begin < this.m_inputMsg.length());
        this.m_inputMsg = buf.toString();
    }

    protected void getNameSpaces(WSDefinition def) {
        String endQuote = "\"";
        String envelopePrefix = "e";
        String s2 = def.getNamespacePrefix("http://schemas.xmlsoap.org/soap/encoding/");
        if (s2 == null) {
            this.m_namespaces.put("http://schemas.xmlsoap.org/soap/encoding/", "soapenc");
        }
        if (def != null) {
            String[] s = def.getNameSpaces();
            int nItems = s == null ? 0 : s.length;
            String xsd = null;
            String xsi = null;
            for (int i = 0; i < nItems; ++i) {
                String nsPrefix = def.getNamespacePrefix(s[i]);
                if (nsPrefix == null || nsPrefix.trim().length() == 0) continue;
                if (nsPrefix.equals(envelopePrefix)) {
                    envelopePrefix = envelopePrefix + "e";
                }
                if (s[i].indexOf("w3.org") != -1 && s[i].indexOf("XMLSchema") != -1) {
                    if (s[i].indexOf("XMLSchema-instance") != -1) {
                        xsi = s[i];
                    } else {
                        xsd = s[i];
                    }
                }
                this.m_namespaces.put(s[i], nsPrefix);
            }
            if (xsd == null) {
                xsd = "http://www.w3.org/2001/XMLSchema";
                this.m_namespaces.put(xsd, "xsd");
            }
            if (xsi == null) {
                this.m_namespaces.put(xsd + "-instance", "xsi");
            }
        }
        this.m_namespaces.put("http://schemas.xmlsoap.org/soap/envelope/", envelopePrefix);
    }

    protected void validate(String msg) throws VWException {
        String m_method = "validate";
        if (this.m_wsDefinition == null || msg == null) {
            return;
        }
        try {
            logger.entering(m_className, m_method);
            String[] schemas = this.m_wsDefinition.getSchemas();
            if (schemas == null) {
                return;
            }
            WSSchemaValidatorResult res = WSSchemaValidator.validate(this.m_wsDefinition.getSchemasTNS(), this.m_op, this.m_wsDefinition.getSchemas(), msg);
            if (!res.getValid()) {
                VWException vwe = new VWException("ws.WSOperations.FailedValidateInputMsg", "Exception: {0}", res.toString());
                System.out.println("Ex=" + vwe.getLocalizedMessage());
                logger.throwing(m_className, m_method, vwe);
                throw vwe;
            }
        }
        catch (VWException vwe) {
            throw vwe;
        }
        catch (Throwable t) {
            throw new VWException(t);
        }
        finally {
            logger.exiting(m_className, m_method);
        }
    }

    protected void validateMessage(WSDefinition definition) throws VWException {
        String m_method = "validateMessage";
        try {
            logger.entering(m_className, m_method);
            String[] schemas = definition.getSchemas();
            if (schemas == null) {
                return;
            }
            WSSchemaValidatorResult res = WSSchemaValidator.validate(definition.getSchemasTNS(), this.m_op, definition.getSchemas(), this.m_inputMsg);
            if (!res.getValid()) {
                VWException vwe = new VWException("ws.WSOperations.FailedValidateInputMsg", "Exception: {0}", res.toString());
                logger.throwing(m_className, m_method, vwe);
                throw vwe;
            }
        }
        catch (VWException vwe) {
            throw vwe;
        }
        catch (Throwable t) {
            throw new VWException(t);
        }
        finally {
            logger.exiting(m_className, m_method);
        }
    }

    protected static boolean isEmpty(String s) {
        return s == null || s.trim().length() == 0;
    }

    protected class MIMEHandler {
        protected WSMessage m_SOAPMsg = null;
        protected String m_className = "MIMEHandler";
        protected Hashtable mimeInfo = null;
        private static final String UNKNOWN = "_UNKNOWN_";

        public boolean hasMIME() {
            return this.mimeInfo != null;
        }

        public IWSAttLoader[] getDocs() {
            if (this.m_SOAPMsg == null) {
                return null;
            }
            String m_method = "getDocs";
            IWSAttLoader[] docs = null;
            docs = this.getAttachments();
            if (docs != null && logger.isFinest()) {
                logger.finest(this.m_className, "getDocs", "Got NDOCS=" + docs.length);
            }
            return docs;
        }

        public MIMEHandler(WSMessage SOAPMsg, WSBindingOperation SOAPOp, boolean isInput) {
            if (SOAPMsg == null) {
                return;
            }
            String m_method = "ctor";
            this.m_SOAPMsg = SOAPMsg;
            logger.entering(this.m_className, m_method);
            this.getMimeInfo(SOAPMsg, SOAPOp, isInput);
            logger.exiting(this.m_className, m_method);
        }

        protected QName getPartInWSMessage(WSMessage SOAPMsg, String partName) {
            if (SOAPMsg == null || partName == null) {
                return null;
            }
            WSPart[] ps = SOAPMsg.getParts();
            int nParts = ps == null ? 0 : ps.length;
            for (int n = 0; n < nParts; ++n) {
                Part p = ps[n].getPart();
                if (!partName.equals(p.getName())) continue;
                QName res = p.getElementName();
                if (logger.isFinest()) {
                    logger.finest(this.m_className, "getPartInWSMessage", "part=" + partName + ", element=" + res.toString());
                }
                return res;
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void getMimeInfo(WSMessage SOAPMsg, WSBindingOperation SOAPOp, boolean isInput) {
            String m_method = "getMimeInfo";
            logger.entering(this.m_className, m_method);
            try {
                WSMIMEPart[] mimeParts;
                WSBindingInOutBase binding = null;
                binding = isInput ? SOAPOp.getBindingInput() : SOAPOp.getBindingOutput();
                if (binding != null && (mimeParts = binding.getMimeParts()) != null && mimeParts.length > 0) {
                    int nParts = mimeParts.length;
                    this.mimeInfo = new Hashtable(nParts);
                    for (int kk = 0; kk < mimeParts.length; ++kk) {
                        MIMEPart pImpl = mimeParts[kk].getMIMEPart();
                        List l = pImpl.getExtensibilityElements();
                        for (Object o : l) {
                            MIMEContent c;
                            QName elementName;
                            if (!(o instanceof MIMEContent) || (elementName = this.getPartInWSMessage(SOAPMsg, (c = (MIMEContent)o).getPart())) == null) continue;
                            this.mimeInfo.put(elementName, c);
                        }
                    }
                }
            }
            finally {
                logger.exiting(this.m_className, m_method);
            }
        }

        protected MIMEContent getMIMEContent(Node p) {
            if (p == null || this.mimeInfo == null) {
                return null;
            }
            String ns = p.getNamespaceURI();
            String localName = p.getLocalName();
            if (ns == null || localName == null) {
                return null;
            }
            QName qName = new QName(ns, localName);
            boolean hasMime = this.mimeInfo.containsKey(qName);
            if (!hasMime) {
                return this.getMIMEContent(p.getParentNode());
            }
            MIMEContent res = (MIMEContent)this.mimeInfo.get(qName);
            if (logger.isFinest()) {
                logger.finest(this.m_className, "getMIMEContent", "Found node=" + p.getNodeName() + " ,part=" + res.getPart() + ", ctype=" + res.getType());
            }
            return res;
        }

        private String getBinaryType(WSParam p) {
            if (p instanceof WSParamLeaf) {
                String typeName = p.getTypeName();
                if (typeName.equals("hexBinary")) {
                    return typeName;
                }
                if (typeName.startsWith("base64")) {
                    return "base64Binary";
                }
                return UNKNOWN;
            }
            if (p instanceof WSParamParent) {
                WSParamParent pp = (WSParamParent)p;
                WSParam[] params = pp.getChildren();
                int nParams = params == null ? 0 : params.length;
                for (int i = 0; i < nParams; ++i) {
                    String res = this.getBinaryType(params[i]);
                    if (!res.equals("hexBinary") && !res.equals("base64Binary")) continue;
                    return res;
                }
            }
            return UNKNOWN;
        }

        private String binaryType(WSMessage m, String partName) {
            WSParam[] params = m.getParamList();
            int nParams = params == null ? 0 : params.length;
            for (int i = 0; i < nParams; ++i) {
                String pName = params[i].getName();
                if (!pName.equals(partName)) continue;
                return this.getBinaryType(params[i]);
            }
            return UNKNOWN;
        }

        private String getBinaryTypeForThisNode(Node n) {
            Node p;
            String name = n.getLocalName();
            String bType = this.binaryType(this.m_SOAPMsg, name);
            if (bType.equals(UNKNOWN) && (p = n.getParentNode()) != null) {
                return this.getBinaryTypeForThisNode(p);
            }
            return bType;
        }

        private void translateAttachmentFunction(StringBuffer buf, String s) {
            int cue = s.indexOf("&lt;fnpo:MIMEATT");
            if (cue == -1) {
                buf.append(s);
                return;
            }
            int endCue = s.indexOf("/&gt;", cue);
            if (endCue == -1) {
                buf.append(s);
                return;
            }
            buf.append(s.substring(0, cue));
            endCue += 5;
            try {
                String ss = s.substring(cue, endCue);
                int hrefStart = ss.indexOf("href=&quot;");
                int hrefEnd = ss.indexOf("&quot;", hrefStart += 11);
                String attString = ss.substring(hrefStart, hrefEnd);
                VWAttachment vwAtt = new VWAttachment(attString);
                if (vwAtt.getType() == 3) {
                    IWSAttLoader doc = WSRequestOperation.this.m_WSAttSession.getLoader(attString);
                    try {
                        byte[] docContents = doc.getContents();
                        buf.append(new String(docContents, "UTF-8"));
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            this.translateAttachmentFunction(buf, s.substring(endCue));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected IWSAttLoader[] getAttachments() {
            String m_method = "getAttachments";
            int nMIMEItems = 0;
            try {
                IWSAttLoader[] iWSAttLoaderArray;
                String wrapperBegin = "<QTESTXXX xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">";
                String wrapperEnd = "</QTESTXXX>";
                StringBuffer buf1 = new StringBuffer();
                this.translateAttachmentFunction(buf1, WSRequestOperation.this.m_inputMsg);
                String myStr = buf1.toString();
                StringBuffer buf = new StringBuffer("<QTESTXXX xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">").append(myStr).append("</QTESTXXX>");
                myStr = buf.toString();
                VWXMLWrapper myStrDoc = new VWXMLWrapper(myStr);
                Vector mimeNodes = new Vector(5);
                VWXMLWrapper.getAllNodesNamedWithPartialNS(myStrDoc.getRootNode(), "http://www.filenet.com/ns/fnpe/20", "MIMEATT", mimeNodes);
                nMIMEItems = mimeNodes.size();
                if (nMIMEItems == 0) {
                    IWSAttLoader[] iWSAttLoaderArray2 = null;
                    return iWSAttLoaderArray2;
                }
                Vector<IWSAttLoader> v = new Vector<IWSAttLoader>(nMIMEItems);
                for (int i = 0; i < nMIMEItems; ++i) {
                    Node n = (Node)mimeNodes.get(i);
                    Node p = n.getParentNode();
                    if (p == null) continue;
                    p.removeChild(n);
                    String attString = VWXMLWrapper.getNodeAttribute(n, "href");
                    IWSAttLoader doc = null;
                    try {
                        VWAttachment vwAtt = new VWAttachment(attString);
                        if (vwAtt.getType() != 3) continue;
                        doc = WSRequestOperation.this.m_WSAttSession.getLoader(attString);
                    }
                    catch (Throwable t) {
                        p.appendChild(myStrDoc.getDocument().createTextNode(attString));
                        continue;
                    }
                    MIMEContent mc = this.getMIMEContent(p);
                    if (mc != null) {
                        myStrDoc.setNodeAttribute(p, "href", "cid:" + doc.getId());
                        if (doc.getLabel() != null) {
                            myStrDoc.setNodeAttribute(p, "docTitle", doc.getLabel());
                        }
                        if (doc.getFileName() != null) {
                            myStrDoc.setNodeAttribute(p, "docFileName", doc.getFileName());
                        }
                        doc.setMimeType(mc.getType());
                        v.add(doc);
                        continue;
                    }
                    try {
                        String encodedDocContents = null;
                        byte[] docContents = doc.getContents();
                        String bType = this.getBinaryTypeForThisNode(p);
                        if (logger.isFinest()) {
                            logger.finest(this.m_className, "getAttachments", p.getLocalName() + ", bType=" + bType);
                        }
                        if (bType.equals("hexBinary")) {
                            encodedDocContents = HexBinary.encode((byte[])docContents);
                            if (logger.isFinest()) {
                                logger.finest(this.m_className, "getAttachments", "hexBinary encoded the document!");
                            }
                        } else if (bType.equals("base64Binary")) {
                            encodedDocContents = Base64.encode((byte[])docContents);
                            if (logger.isFinest()) {
                                logger.finest(this.m_className, "getAttachments", "base64 encoded the document!");
                            }
                        } else {
                            if (logger.isFinest()) {
                                logger.finest(this.m_className, "getAttachments", "Use the default encoding (UTF-8).");
                            }
                            encodedDocContents = new String(docContents);
                        }
                        p.appendChild(myStrDoc.getDocument().createTextNode(encodedDocContents));
                        continue;
                    }
                    catch (Throwable t) {
                        logger.throwing(this.m_className, "getAttachments", t);
                    }
                }
                myStr = myStrDoc.toXML(myStrDoc.getRootNode());
                int iii = myStr.indexOf("<QTESTXXX xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">");
                if (iii < 0) {
                    iii = 0;
                }
                int ii = myStr.indexOf(62, iii) + 1;
                int jj = myStr.lastIndexOf("</QTESTXXX>");
                WSRequestOperation.this.m_inputMsg = myStr = myStr.substring(ii, jj);
                if (logger.isFinest()) {
                    logger.finest(this.m_className, "getAttachments", WSRequestOperation.this.m_inputMsg);
                }
                if (v.size() > 0) {
                    iWSAttLoaderArray = v.toArray(new IWSAttLoader[0]);
                    return iWSAttLoaderArray;
                }
                iWSAttLoaderArray = null;
                return iWSAttLoaderArray;
            }
            catch (Throwable t) {
                logger.throwing(this.m_className, "getAttachments", t);
                IWSAttLoader[] iWSAttLoaderArray = null;
                return iWSAttLoaderArray;
            }
            finally {
                logger.exiting(this.m_className, "getAttachments");
            }
        }
    }
}

